;;; 
;;; Virtual Disk Drive Project	- Nov 11, 2003 (EJR)
;;;
;;; Simple Wait routines - used in generating data delays

#include "vd.h"
#include "headmove.mac"
	
;; These are placed in code page 2 because they are exclusively called
;; when generating sectors
	
PROG2 CODE
   global Wait6c	      ; the following are "call" versions of "Wait"
   global Wait7c
   global Wait8c
   global Wait9c
   global Wait10c
   global Wait11c
   global Wait12c
   global Wait13c
   global Wait14c
   global Wait15c
   global Wait16c
   global Wait17c
   global Wait18c
   global Wait19c
   global Wait20c
   global Wait21c
   global Wait22c
   global Wait23c
   global Wait24c
   global Wait25c

;;;**********************************************************************
;;; NAME:	Wait Calls
;;;
;;; DESCR:	Wait for a time.  Use the spare time to call headcheck().
;;;
;;;		Since a call takes 2, and a return takes 2, the smallest
;;;		wait that can be done with a call is 4 instruction cycles.
;;;
;;;
;;; ARGS:	None
;;;
;;; RETURNS:	Nada
;;;
;;; NOTES:	- this used to be a real pretty cascade of waits that
;;;		  looked like:
;;;
;;;			...
;;;			Wait17c:	nop
;;;			Wait16c:	nop
;;;			Wait15c:	nop
;;;			Wait14c:	nop
;;;			...
;;;		   But it was changed to do as many HeadChecks as possible
;;;		   while waiting...why not?
;;;		- HeadChecks are done every 4 instruction cycles for
;;;		  waits 6 or longer
;;;**********************************************************************

Wait25c:	nop
Wait24c:	nop	
Wait23c:	nop	
Wait22c:	HeadCheck
		goto	Wait18c

Wait21c:	nop
Wait20c:	nop	
Wait19c:	nop	
Wait18c:	HeadCheck
		goto	Wait14c

Wait17c:	nop
Wait16c:	nop
Wait15c:	nop
Wait14c:	HeadCheck
		goto	Wait10c
	
Wait13c:	nop
Wait12c:	nop
Wait11c:	nop
Wait10c:	HeadCheck
		goto	Wait6c
	
Wait9c:		nop		; fall through to Wait8
Wait8c:		nop		; fall through to Wait7
Wait7c:		nop		; fall through to Wait6
Wait6c:		HeadCheck
		return

;;; ---------------------------------------------------------------------------
;;; ---------------------------------------------------------------------------
	
	END
